definition module type_io_equal_types


from typetable import :: TypeTable
from type_io_read import :: TypeTableTypeReference, :: TypeIOState, :: TIO_CommonDefs
from StdDynamicTypes import :: TIO_TypeReference
		
// converts a a type reference into an (unique) index
compute_index_in_type_cache :: !TIO_TypeReference !TIO_TypeReference !*TypeIOState -> (!Int,!*TypeIOState)

class EqTypes a
where
	equal_types :: a a !*{#TIO_CommonDefs} !*TypeIOState -> (!Bool,!*{#TIO_CommonDefs},!*TypeIOState)
	
instance EqTypes TIO_TypeReference

:: OrderedTypeRef
	= {
		otr_type_ref1	:: TypeTableTypeReference
	,	otr_type_ref2	:: TypeTableTypeReference
	};
	
:: *EqTypesState
	= {
		ets_within_type_table			:: !Bool	// iff ets_left_i == ets_right_i

	,	ets_left_i						:: !Int		// type table index for left type (1st arg)
	,	ets_right_i						:: !Int		// type table index for right type (2nd arg)
	
	,	ets_left_module_i				:: !Int		// left module index
	,	ets_right_module_i				:: !Int		// right module index
	
	,	ets_assumed_type_equivalences	:: [OrderedTypeRef]
	,	ets_proven_type_equivalences	:: [OrderedTypeRef]
	
	,	ets_left_string_table			:: !String
	,	ets_right_string_table			:: !String
	};  
	
default_eq_types_state :: *EqTypesState;

class EqTypesExtended a
where
	equal_type_defs :: !a !a !{#*TypeTable} !*EqTypesState -> (!Bool,!{#*TypeTable},!*EqTypesState)
	
instance EqTypesExtended TypeTableTypeReference;
